function [outputArg1,outputArg2] = PropRes(inputArg1,inputArg2)
% 画ROI区域，有反应位点比例随时间变化图
%   此处提供详细说明

workpath='E:\Software\brainstorm_db\Protocol01\data\TotalSub\6sub\';
ChanFile=load([workpath,'channel_221021_1815.mat']);
SubNum=6;
Res_Screen=1920;
for i_sub=1:SubNum
    DataPath=['E:\DATA_SEEG\',FullNameT{i_sub},'_data\处理数据集\',SimplyNameT{i_sub},'_VisualAwareData\'];
    dataList=dir([DataPath,'*_VisualAware_*.mat']);
    load([DataPath,dataList(1).name]);
    LR_sti1(i_sub)=Trial(1).Sti.LocX;
end
    LR_sti=(LR_sti1>Res_Screen/2)+1;  % 1 左，2右

ChanLabel=[];
for i_chan=1:length(ChanFile.Channel)
    ChanLabel{1,i_chan}=ChanFile.Channel(i_chan).Name;
end
% for i_LR=1:length(Cri_Chan_LR)
    Cri_Chan_IpsiContra={};
    Cri_Chan(SubNum+1:end)=[];
   for i_sub=1:length(LR_sti)
   if LR_sti(i_sub)==1
    Cri_Chan_IpsiContra{1}(i_sub)=Cri_Chan_LR{1}(i_sub);
    Cri_Chan_IpsiContra{2}(i_sub)=Cri_Chan_LR{2}(i_sub);
   elseif LR_sti(i_sub)==2
   Cri_Chan_IpsiContra{1}(i_sub)=Cri_Chan_LR{2}(i_sub);
   Cri_Chan_IpsiContra{2}(i_sub)=Cri_Chan_LR{1}(i_sub);
   end
   end

for i_IC=1:length(Cri_Chan_LR)
Cri_Chan=Cri_Chan_IpsiContra{i_IC};

i_chanT=1;
RTepoch={};
for i_sub=1:length(Cri_Chan)
     Chan_temp=Cri_Chan(i_sub).roi;
    for i_chan=1:length(Chan_temp)
       NameTemp=Cri_Chan(i_sub).name1;
       NameTemp1=strcat(Chan_temp{i_chan},'_',NameTemp);
       [Lia,Locb]=ismember(NameTemp1,ChanLabel);
       RTepoch{2,i_chanT}=Result(1).RTepochT{Locb}; % HG
       RTepoch{1,i_chanT}=Result(2).RTepochT{Locb}; % 2ERP 1HG
       i_chanT=i_chanT+1;
    end
end

Time=0:650;
DataType={'ERP','HG'};
Fraction1=[];
for i_data=1:size(RTepoch,1)
Data_temp=zeros(size(RTepoch,2),numel(Time));
for i_chan=1:length(RTepoch) 
temp=RTepoch{i_data,i_chan};
if isempty(temp)
continue
end
for i_temp=1:size(temp,2)
Data_temp(i_chan,temp(1,i_temp):temp(2,i_temp))=1;
end
end

RespN=[];
for i_time=1:size(Time,2)
RespN(i_time)=numel(find(Data_temp(:,i_time)~=0));
end
TotalN=size(Data_temp,1);
Fraction=RespN./TotalN*100;
Fraction1(i_data,:)=smoothdata(Fraction,2,'movmean',20);
figure;
plot(Time,Fraction1(i_data,:),'LineWidth',2)
ylabel('Fractions of awareness-related sites (%)')
xlabel('Time from  Cue Onset (ms)')
title(['n=',num2str(size(Data_temp,1)),' sites'])
% xline(650,'k--','LineWidth',2);
xlim([0,650])
box off
ax=gca;
ax.FontSize=15;
ax.LineWidth=2;

% SavePath='E:\DATA_SEEG\elifeReviewResults\';
% saveas(gcf,[SavePath,'Fractions of Resp Sites',DataType{i_data},'.fig']);
% saveas(gcf,[SavePath,'Fractions of Resp Sites',DataType{i_data},'.tif']);
end


Fraction1_temp{i_IC}=Fraction1;
Fraction1=[Fraction1_temp{1}(1,:);Fraction1_temp{2}(1,:)];
Fraction1=[Fraction1_temp{1}(2,:);Fraction1_temp{2}(2,:)];

figure;
h=plot(Time,Fraction1,'LineWidth',2);
% h(1).Color=[0.6350 0.0780 0.1840];
% h(2).Color=[0.4660 0.6740 0.1880];
ylabel('Fractions of awareness-related sites (%)')
xlabel('Time from  Cue Onset (ms)')
title(['Parsopercularis & MFG (n=',num2str(size(Data_temp,1)),' sites)'])
% title(['HG'])
% xline(650,'k--','LineWidth',2);
xlim([0,650])
box off
ax=gca;
ax.FontSize=15;
ax.LineWidth=2;
legend(DataType,'Location','northwest');
% legend({'Peri-insula & MFG (n=145)','Others (n=100)'},'Location','northwest');
legend boxoff

SavePath='E:\DATA_SEEG\elifeReviewResults\';
saveas(gcf,[SavePath,'Fractions of Resp Sites_SubRegions_ERP&HG.fig']);
saveas(gcf,[SavePath,'Fractions of Resp Sites_SubRegions_ERP&HG.tif']);

end

% 计算不同脑亚区有反应位点比例
Num_Roi=[];
Num_SubRegion=[];
Num_SubRegion1=[];
for i_sub=1:length(Cri_Chan)

Num_Roi(1,i_sub)=size(Cri_Chan(i_sub).roi,1); %重要区域
Num_Roi(2,i_sub)=size(Cri_Chan1(i_sub).roi,1);%其他区域

Num_SubRegion(1,i_sub)=size(Cri_Chan(i_sub).erp,1);
Num_SubRegion(2,i_sub)=size(Cri_Chan1(i_sub).erp,1);

Num_SubRegion1(1,i_sub)=size(Cri_Chan(i_sub).HG,1);
Num_SubRegion1(2,i_sub)=size(Cri_Chan1(i_sub).HG,1);
end
Ratio=Num_SubRegion./Num_Roi*100;
Ratio1=Num_SubRegion1./Num_Roi*100;

Ratio(:,3)=[];
Ratio1(:,3)=[];

figure;
hold on;
scatter(Ratio(1,:),Ratio(2,:),'MarkerFaceColor',[0 0.4470 0.7410],'MarkerEdgeColor',[0 0.4470 0.7410]);
scatter(Ratio1(1,:),Ratio1(2,:),'MarkerFaceColor',[0.8500 0.3250 0.0980],'MarkerEdgeColor',[0.8500 0.3250 0.0980]);
line([0,100],[0,100],'Color',[0.7 0.7 0.7],'LineStyle','--','LineWidth',1.5);
ax=gca;
ax.FontSize=18;
ax.LineWidth=1.5;
xlabel('Fractions in Peri-insula regions & MFG (%)');
ylabel('Fractions in other regions (%)')
legend(DataType,'Location','northwest')
legend boxoff
title('N=5')
SavePath='E:\DATA_SEEG\elifeReviewResults\';
saveas(gcf,[SavePath,'Fractions of Resp Sites_SubRegions_SSUB.fig']);
saveas(gcf,[SavePath,'Fractions of Resp Sites_SubRegions_SSUB.tif']);

end